#!/bin/bash
#2025-1-15

mkdir -p /data/opengauss_backup/
BACKUP_DIR=/data/opengauss_backup
CONF=/data/ops/config.ini

OFFLINE_CONFIG_ROOT_KEY_COMPONENT1=$(grep "OFFLINE_CONFIG_ROOT_KEY_COMPONENT1" ${CONF} | awk -F = '{print $2}')
OFFLINE_CONFIG_ROOT_KEY_SALT=$(grep "OFFLINE_CONFIG_ROOT_KEY_SALT" ${CONF} | awk -F = '{print $2}')
PAAS_MYSQL_PASSWORD=$(grep "PAAS_MYSQL_PASSWORD=" ${CONF} | awk -F PAAS_MYSQL_PASSWORD= '{print $2}')
PASSWORD=$(/data/ops/cert/amah_tool -role=config -root_key.component1=${OFFLINE_CONFIG_ROOT_KEY_COMPONENT1} -root_key.salt=${OFFLINE_CONFIG_ROOT_KEY_SALT} -ciphertext=${PAAS_MYSQL_PASSWORD})

filename=`date +%Y%m%d`
gs_dump -h 3333 -p 5433 -U gaussdb -W ${PASSWORD} --schema=jvs_csg  -Fp  jvs_csg -f $BACKUP_DIR/${filename}_jvs_csg.sql  >/dev/null 2>&1
gs_dump -h 3333 -p 5433 -U gaussdb -W ${PASSWORD} --schema=jvs_dcgm -Fp  jvs_dcgm -f $BACKUP_DIR/${filename}_jvs_dcgm.sql >/dev/null 2>&1
gs_dump -h 3333 -p 5433 -U gaussdb -W ${PASSWORD} --schema=jvs_dms  -Fp  jvs_dms -f $BACKUP_DIR/${filename}_jvs_dms.sql >/dev/null 2>&1
gs_dump -h 3333 -p 5433 -U gaussdb -W ${PASSWORD} --schema=jvs_eas  -Fp  jvs_eas -f $BACKUP_DIR/${filename}_jvs_eas.sql >/dev/null 2>&1
gs_dump -h 3333 -p 5433 -U gaussdb -W ${PASSWORD} --schema=jvs_mrs  -Fp  jvs_mrs -f $BACKUP_DIR/${filename}_jvs_mrs.sql >/dev/null 2>&1
gs_dump -h 3333 -p 5433 -U gaussdb -W ${PASSWORD} --schema=jvs_cas  -Fp  jvs_cas -f $BACKUP_DIR/${filename}_jvs_cas.sql >/dev/null 2>&1
gs_dump -h 3333 -p 5433 -U gaussdb -W ${PASSWORD} --schema=jvs_pcg  -Fp  jvs_pcg -f $BACKUP_DIR/${filename}_jvs_pcg.sql >/dev/null 2>&1
gs_dump -h 3333 -p 5433 -U gaussdb -W ${PASSWORD} --schema=jvs_cms  -Fp  jvs_cms -f $BACKUP_DIR/${filename}_jvs_cms.sql >/dev/null 2>&1
gs_dump -h 3333 -p 5433 -U gaussdb -W ${PASSWORD} --schema=mix_saas -Fp  mix_saas -f $BACKUP_DIR/${filename}_mix_saas.sql >/dev/null 2>&1


cd $BACKUP_DIR
tar czvf ${filename}_jvs_csg.sql.tar.gz ${filename}_jvs_csg.sql
tar czvf ${filename}_jvs_dcgm.sql.tar.gz ${filename}_jvs_dcgm.sql
tar czvf ${filename}_jvs_dms.sql.tar.gz ${filename}_jvs_dms.sql
tar czvf ${filename}_jvs_eas.sql.tar.gz ${filename}_jvs_eas.sql
tar czvf ${filename}_jvs_mrs.sql.tar.gz ${filename}_jvs_mrs.sql
tar czvf ${filename}_jvs_cas.sql.tar.gz ${filename}_jvs_cas.sql
tar czvf ${filename}_jvs_pcg.sql.tar.gz ${filename}_jvs_pcg.sql
tar czvf ${filename}_jvs_cms.sql.tar.gz ${filename}_jvs_cms.sql
tar czvf ${filename}_mix_saas.sql.tar.gz ${filename}_mix_saas.sql

sleep 5
rm -rf *.sql
