#!/bin/bash
#小马哥
#2022-06-14
#中间件部署

middle_path=/data/middle/
app_user=mix_usr
path=/root/installTool
timestamp=$(date +%F-%T)

tar xfzv /root/middle.tar.gz  -C ${middle_path}

echo "export JAVA_HOME=/data/middle/jre1.8.0_451" >> /etc/profile.d/java.sh
echo 'export PATH=${JAVA_HOME}/bin:$PATH' >> /etc/profile.d/java.sh
chown ${app_user}. -R /etc/profile.d/java.sh
source /etc/profile.d/java.sh

#tar xfzv ${path}/ops.tar.gz -C /data/

cp -r ${path}/config.ini  /data/ops/
cp -r ${path}/httpsflv2.tpl /data/ops/nginx/conf.d/httpsflv2.conf
cp -r ${path}/mix_saas9099.tpl /data/ops/nginx/conf.d/mix_saas9099.conf

#2024-4-12新增
cp -r ${path}/configdb.ini  /data/ops/
cp -r ${path}/mysqluserinstall.sh  /data/ops/

#2023-5-9因主从新增并拷贝相关配置
cp -r ${path}/rabbitmq.conf  ${middle_path}/rabbitmq/etc/rabbitmq/
cp -r ${path}/redis.conf  ${middle_path}/redis/
cp -r ${path}/paas_inside9081.conf  /data/ops/nginx/conf.d/
cp -r ${path}/redis_flush_mix.sh  ${middle_path}/redis/
cp -r ${path}/redis_reset.sh  ${middle_path}/redis/
cp -r ${path}/autobackupdb.sh  /data/ops/
cp -r ${path}/postgresql.conf  ${middle_path}/openGauss/data/single_node/
cp -r ${path}/nginx.conf  /data/ops/nginx/
cp -r ${path}/pg_hba.conf  ${middle_path}/openGauss/data/single_node/
sleep 5s
rm -rf ${path}/rabbitmq.conf
rm -rf ${path}/redis.conf
rm -rf ${path}/import_sql
rm -rf ${path}/paas_inside9081.conf
rm -rf ${path}/redis_flush_mix.sh
rm -rf ${path}/autobackupdb.sh
rm -rf ${path}/redis_reset.sh
rm -rf ${path}/postgresql.conf
rm -rf ${path}/nginx.conf
rm -rf ${path}/nginx_ipv6.conf
rm -rf ${path}/pg_hba.conf


#2025-2-8新增gsdb校时系统时区时间
dbdate1=/data/middle/openGauss/data/single_node/postgresql.conf
cp -arp $dbdate1 /data/middle/openGauss/data/single_node/postgresql.conf_bak
cp -arp $dbdate1 $dbdate1-bak$timestamp
sed -i "s#timezone = '.*'#timezone = '$(timedatectl | awk -F'(' '/Time zone/ {print $1}' | awk '{print $3}')'#" "$dbdate1"

#2024-5-30redis
cd ${middle_path}/redis/ && ./redis_reset.sh && rm -rf redis_reset.sh

chown -R ${app_user}. /data

cat >> /var/spool/cron/mix_usr << EOF
50 23  * * * /data/ops/autobackupdb.sh
50 23  * * * /data/ops/auto-del.sh
0 0 */1 * * /data/ops/download.sh
*/1 * * * * /data/ops/control server start
*/1 * * * * /data/ops/control middle start
EOF

chown -R ${app_user}. /var/spool/cron/

function start_middle() {
su - ${app_user} << EOF
${middle_path}/consul/dog start && echo "Consul启动"
${middle_path}/nginx/dog start && echo "Nginx 启动"
${middle_path}/rabbitmq/dog start && echo "RabitMQ 启动"
${middle_path}/redis/dog start && echo "Redis 启动"
${middle_path}/openGauss/dog start && echo "openGauss 启动"
sleep 5s
cd /data/middle/openGauss/bin/ && ./import_sql
sleep 10s
cd /data/ops/ && ./mysqluserinstall.sh
sleep 30s
cd ${middle_path}/rabbitmq/ && ./rabbitmq_init.sh && ./rabbitmq_operation_init.sh
EOF
sleep 10s
cd /data/middle/redis/ && ./redis_flush_mix.sh
}


function start_jaws() {
<< EOF
cp -r ${path}/config.ini /data/ops/
EOF
}



tar xfzv ${path}/jaws.tar.gz -C /data/
tar xfzv ${path}/download.tar.gz -C /data/
start_middle && start_jaws

chown -R ${app_user}. /data

#用于dcg_third
cp -arp /data/jaws/dcg_third/config/libs/* /usr/lib64/
#chown mix_usr.mix_usr -R /usr/lib64/libFEC.so  /usr/lib64/libhwpusdk.so /usr/lib64/libjson-c.so /usr/lib64/libjson-c.so.5 /usr/lib64/libSEC.so
#2025-3-13用于媒体
cp -arp /data/jaws/mps/config/libs/* /usr/lib64/




#chronyd-arm
mv /etc/chrony.conf /etc/chrony.conf-bak$timestamp
cp -r ${path}/chrony.conf  /etc/
systemctl start chronyd
systemctl enable chronyd
rm -rf ${path}/chrony.conf


#清理动作解决部署包后残留内置证书
rm -rf /root/installTool/zhengshu
rm -rf /root/installTool/ops.tar.gz
#清理db脚本
rm -rf /root/installTool/configdb.ini
rm -rf /root/installTool/mysqluserinstall.sh
rm -rf /data/ops/configdb.ini
rm -rf /data/ops/mysqluserinstall.sh
#清理离线安装包,arm暂不启用
rm -rf /root/installTool/rpm

function control_ceshi() {
su - ${app_user}  << EOF

ps -ef |grep nginx ; ps -ef |grep gaussdb ; ps -ef |grep rabbitmq ; ps -ef |grep redis ; ps -ef |grep consul ; ps -ef |grep  main.py

/data/ops/control server restart
sleep 50s
/data/ops/control server start
sleep 30s
/data/ops/control server start
sleep 30s

/data/ops/control server status
EOF
}
control_ceshi

serverList="nginx|9099 redis|6379 consul|8500 gaussdb|5433 beam.smp|15672 amah_agent|12000 csps|7230 dash|20397 dcg_third|21120 gbmts|7260 hflv|20375 jvmts|7071 mfss|20130 mps|20355 mrs|7210 ystmts|22000  java|8110 java|9110 cms|20100 wsmts|20379"
result=""
fail=0
for item in $serverList; do
    server=${item%%|*}
    port=${item#*|}
    checkPort=$(netstat -lntup | grep ":$port " | grep LISTEN | wc -l)
    if [ $checkPort -ge 1 ]; then
        checkServer=$(ps -fe | grep $server | grep -v grep | wc -l)
        if (($checkServer != 0)); then
            #result="$server服务运行中，${result}"
            a=1
        else
            result="$server服务未运行，${result}"
            fail=1
        fi
    else
        result="$server服务未运行，${result}"
        fail=1
    fi

done

if (($fail == 0)); then
    echo -e "`date +%F-%H-%M` \033[32m ZhongWei have been installed successfully.\033[0m"
else
    echo -e "`date +%F-%H-%M` \033[31m ZhongWei installed falied.\033[0m"

fi
# 删除最后一个逗号
result=${result%?}
echo $result >/root/installTool/zhongwei.txt

