server {
    listen 1.1.1.1:9099 ssl;
    server_name jaws9099;
    client_max_body_size 500m;
    ssl_certificate /data/ops/cert/nginx/saas.pem;
    ssl_certificate_key /data/ops/cert/nginx/saas.key;
    
    ssl_session_cache    shared:SSL:1m;
    ssl_session_timeout  5m;

    ssl_ciphers ECDHE-ECDSA-AES128-GCM-SHA256:ECDHE-RSA-AES128-GCM-SHA256:ECDHE-ECDSA-AES256-GCM-SHA384:ECDHE-RSA-AES256-GCM-SHA384:ECDHE-ECDSA-CHACHA20-POLY1305:ECDHE-RSA-CHACHA20-POLY1305:DHE-RSA-AES128-GCM-SHA256:DHE-RSA-AES256-GCM-SHA384;
    ssl_prefer_server_ciphers  on;
    ssl_protocols TLSv1.2;

    if ( $time_iso8601 ~ "^(\d{4})-(\d{2})-(\d{2})" ) {
        set $year $1;
        set $month $2;
        set $day $3;
    }

    access_log  /data/log/middle/nginx/jaws-9090-$year-$month-$day-access.log main;
    error_log  /data/log/middle/nginx/jaws-9090-error.log  notice;
    location ^~/v3 {
        limit_except GET POST OPTIONS {
            deny all;
        }

        add_header X-Frame-Options SAMEORIGIN;
        add_header Access-Control-Allow-Origin *;
        add_header Access-Control-Allow-Credentials true;
        add_header Access-Control-Allow-Methods 'GET, POST, OPTIONS';
        add_header Access-Control-Allow-Headers 'DNT,X-Mx-ReqToken,Keep-Alive,User-Agent,X-Requested-With,If-Modified-Since,Cache-Control,Content-Type,X-User,X-Date,X-Sign,X-SessionID';
        #add_header Content-Security-Policy "default-src 'self'; frame-ancestors 'none';form-action 'self' ; script-src 'self' ; style-src 'self' ; img-src 'self' data:";
        add_header Content-Security-Policy "default-src 'self'; script-src 'self' 'unsafe-inline' 'unsafe-eval'; style-src 'self'; img-src 'self' data:; connect-src 'self' wss://*:*;";
          

        if ($request_uri ~* '/actuator/health') {
           return 403;
        }

        if ( $request_method = 'OPTIONS' ) {
            return 200;
        }

        proxy_http_version 1.1;
        proxy_pass         http://127.0.0.1:9110/v3;
        proxy_set_header   Host             $host:9090;
        proxy_set_header X-Jovision-For $remote_addr;
        proxy_set_header   X-Real-IP        $remote_addr;
        proxy_set_header   X-Forwarded-For  $proxy_add_x_forwarded_for;
        proxy_redirect     off;

        proxy_connect_timeout 6000s;
        proxy_send_timeout    300s;
        proxy_read_timeout    300s;
    }

    
    location ^~/v3/basic {
        if ($request_uri ~* '/actuator/health') {
           return 403;
        }
        proxy_connect_timeout 200;
        client_max_body_size 500m;
        proxy_pass http://127.0.0.1:9110/v3/basic;
        proxy_set_header X-Jovision-For $remote_addr;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_set_header X-Real-IP $remote_addr;
    }
	
    location ^~/v3/message {
        if ($request_uri ~* '/actuator/health') {
           return 403;
        }
        proxy_connect_timeout 200;
        client_max_body_size 500m;
        proxy_pass http://127.0.0.1:9110/v3/message;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_set_header X-Real-IP $remote_addr;
    }
	
    location ^~/v3/upms {
        if ($request_uri ~* '/actuator/health') {
           return 403;
        }
        proxy_connect_timeout 200;
        client_max_body_size 500m;
        proxy_pass  http://127.0.0.1:9110/v3/upms;
        proxy_set_header X-Jovision-For $remote_addr;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_set_header X-Real-IP $remote_addr;
    }
   

    location ^~/v3/ops {
        if ($request_uri ~* '/actuator/health') {
           return 403;
        }
        proxy_connect_timeout 200;
        client_max_body_size 500m;
        proxy_pass  http://127.0.0.1:9110/v3/ops;
        proxy_set_header X-Jovision-For $remote_addr;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_set_header X-Real-IP $remote_addr;
    }

    location ^~/v3/auth {
        if ($request_uri ~* '/actuator/health') {
           return 403;
        }
        proxy_connect_timeout 200;
        client_max_body_size 500m;
        proxy_set_header Upgrade $http_upgrade;
        proxy_set_header Connection "Upgrade";
        proxy_pass http://127.0.0.1:8110/v3/auth;
        proxy_set_header X-Jovision-For $remote_addr;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_set_header X-Real-IP $remote_addr;
    }
	
    location ^~/v3/file {
        if ($request_uri ~* '/actuator/health') {
           return 403;
        }
        proxy_connect_timeout 2000;
        client_max_body_size 500m;
        proxy_pass http://127.0.0.1:9110/v3/file;
        proxy_http_version 1.1;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_request_buffering off;
        proxy_set_header X-Real-IP $remote_addr;
    }
	
    location ^~/monitor {
        if ($request_uri ~* '/actuator/health') {
           return 403;
        }
        proxy_connect_timeout 200;
        client_max_body_size 500m;
        proxy_pass http://127.0.0.1:9110/monitor;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_set_header X-Real-IP $remote_addr;
    }
    location ^~/v3/event {
        if ($request_uri ~* '/actuator/health') {
           return 403;
        }
        proxy_connect_timeout 200;
        client_max_body_size 500m;
        proxy_pass http://127.0.0.1:8210/v3/event;
        proxy_set_header X-Jovision-For $remote_addr;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_set_header X-Real-IP $remote_addr;
    }
   
    location ^~/v3/video {
        if ($request_uri ~* '/actuator/health') {
           return 403;
        }
        proxy_connect_timeout 200;
        client_max_body_size 500m;
        proxy_pass http://127.0.0.1:9710/v3/video;
        proxy_set_header X-Jovision-For $remote_addr;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_set_header X-Real-IP $remote_addr;
    }

	location ^~/v3/env {
        if ($request_uri ~* '/actuator/health') {
           return 403;
        }
        proxy_connect_timeout 200;
        client_max_body_size 500m;
        proxy_pass http://127.0.0.1:9710/v3/env;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_set_header X-Real-IP $remote_addr;
    }

    location ^~/rs/env {
        if ($request_uri ~* '/actuator/health') {
           return 403;
        }
        proxy_connect_timeout 200;
        client_max_body_size 500m;
        proxy_pass http://127.0.0.1:9710/v3/env/sensor;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_set_header X-Real-IP $remote_addr;
    }
	
  location ^~/v3/guard {
        if ($request_uri ~* '/actuator/health') {
           return 403;
        }
        proxy_connect_timeout 200;
        client_max_body_size 500m;
        proxy_pass http://127.0.0.1:9710/v3/guard;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_set_header X-Real-IP $remote_addr;
    }
    location ^~/v3/open {
        if ($request_uri ~* '/actuator/health') {
           return 403;
        }
            proxy_connect_timeout 200;
            proxy_pass http://127.0.0.1:8810/v3/open;
            proxy_set_header X-Forwarded-Proto $scheme;
            proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
            proxy_set_header X-Real-IP $remote_addr;
	    proxy_set_header Host $Host:$server_port;
	    add_header Access-Control-Allow-Origin *;
            add_header Access-Control-Allow-Credentials true;
            add_header Access-Control-Allow-Methods 'GET, POST, OPTIONS';
            add_header Access-Control-Allow-Headers 'X-Token,DNT,X-Mx-ReqToken,Keep-Alive,User-Agent,X-Requested-With,If-Modified-Since,Cache-Control,Content-Type,X-User,X-Date,X-Sign,X-SessionID';
    if ( $request_method = 'OPTIONS' ) {
        return 200;
    }
        }
   
    location ^~/v3/inner {
            return 403;
        }

    location /faces/ {
	    alias /snap/faces/;
	}

    location /proto/ {
            alias /data/jaws/proto/;
        }

    location /proto2/ {
            alias /data/jaws/proto2/;
        }

    location / {
       
        limit_except GET POST OPTIONS {
            deny all;
        }
	if ($uri ~ ^/((?!js)(?!img)(?!css)(?!fonts)(?!wasm)(?!ico).)*$) {
        add_header Cache-Control no-store;

            rewrite .* /index.html break;
        }
        root    /data/jaws/web;
        index   index.html;
    }
     location /app {
        alias   /data/jaws/app;
        index   index.html;
        }
     location /pc {
    	alias   /data/jaws/pc;
    	index   index.html;
    	}     

    location /download{
      root                  /data;
      #limit_rate_after      1000k;
      limit_rate            2000k;
      autoindex_exact_size  off;
      autoindex_localtime   on;
    }
}
