#!/bin/bash
#2025-3-17

source /etc/profile.d/opengauss.sh

CONF=/data/ops/configdb.ini
OFFLINE_CONFIG_ROOT_KEY_COMPONENT1=$(grep "OFFLINE_CONFIG_ROOT_KEY_COMPONENT1" ${CONF} | awk -F = '{print $2}')
OFFLINE_CONFIG_ROOT_KEY_SALT=$(grep "OFFLINE_CONFIG_ROOT_KEY_SALT" ${CONF} | awk -F = '{print $2}')





#新db_operation
OPERATION_MYSQL_USER=$(grep "OPERATION_MYSQL_USER=" ${CONF} | awk -F OPERATION_MYSQL_USER= '{print $2}')
ROOTINSTALL3=$(/data/ops/cert/amah_tool -role=config -root_key.component1=${OFFLINE_CONFIG_ROOT_KEY_COMPONENT1} -root_key.salt=${OFFLINE_CONFIG_ROOT_KEY_SALT} -ciphertext=${OPERATION_MYSQL_USER})


# 用户定义的数据库列表
DBS=("jvs_cas" "jvs_cms" "jvs_csg" "jvs_dcgm" "jvs_dms" "jvs_eas" "jvs_mrs" "jvs_pcg" "mix_saas")

# 用户
USER="db_operation"

# 当前连接的目标数据库（通常用 postgres）
MAIN_DB="postgres"

# 以管理员身份先创建用户
gsql -d $MAIN_DB -p 5433 <<EOF
CREATE USER $USER WITH PASSWORD '${ROOTINSTALL3}';
UPDATE pg_database SET datconnlimit = 1024 WHERE datname IN (
  'school', 'finance', 'jvs_csg', 'jvs_dcgm', 'jvs_dms',
  'postgres', 'jvs_eas', 'jvs_mrs', 'jvs_cas', 'jvs_pcg',
  'jvs_cms', 'mix_saas'
);
ALTER ROLE gaussdb CONNECTION LIMIT 1024;
ALTER ROLE db_operation CONNECTION LIMIT 1024;
EOF

# 循环所有数据库，执行授权语句
for DB in "${DBS[@]}"; do
    echo "正在处理数据库: $DB  >/dev/null 2>&1"
    gsql -d $DB -p 5433 <<EOF
-- 切换到当前数据库
\c $DB

GRANT USAGE ON SCHEMA "$DB" TO $USER;

GRANT ALL PRIVILEGES ON ALL TABLES IN SCHEMA "$DB" TO $USER;

GRANT ALL PRIVILEGES ON ALL SEQUENCES IN SCHEMA "$DB" TO $USER; 

GRANT ALL PRIVILEGES ON ALL FUNCTIONS IN SCHEMA "$DB" TO $USER;
EOF
done

