#!/bin/bash

#!/bin/bash
# Description: 本机运行服务列表，涉及系统目录，需要root权限
# Author:      
# Date:        2024/12/06
# Usage:       ./server_list.sh
set -euo pipefail



root_need() {
    if [[ $EUID -ne 0 ]]; then
        echo -e "Error:Need root user to run!"
        exit 1
    fi
}
root_need
#根据实际情况修改配置
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
ser_run_path="/data/jaws"
#当前运行的大版本
version="v4.0.4"
url="127.0.0.1"
server_list=/data/ops/server
#------------------------------------------------

if [ ! -d "/var/log/applogs/customprocess" ]; then
    mkdir -p "/var/log/applogs/customprocess"
fi

if [ ! -f "/var/log/applogs/customprocess/processKey.properties" ]; then
    touch "/var/log/applogs/customprocess/processKey.properties"
    #chown -R omagent. /var/log/applogs/customprocess
    chown -R 8573:8573 /var/log/applogs/customprocess
    chmod 755 /var/log/applogs
    chmod 750 /var/log/applogs/customprocess
    chmod 640 /var/log/applogs/customprocess/processKey.properties
fi



#部署之前不运行以下脚本
if [ ! -f "${server_list}" ]; then
    echo 0
fi


list() {
    while IFS= read -r line; do
        ser_path=$(echo "$line" | awk '{print $1}')
        ser_name=$(echo "$line" | awk '{print $2}')
	echo "process:${ser_run_path}/${ser_path}/${ser_name}=${ser_name}|ZhongWei|mix_usr|JOVISION|${version}|转码|transcode|https://${url}:9099"
    done < /data/ops/server
}

list > /var/log/applogs/customprocess/processKey.properties
