#!/bin/bash
#小马哥
#2022-06-14
#系统初始化脚本

if [ "${1}" = "" ];then
		echo "请输入监听IP地址"
			exit 1
fi

if [ "${2}" = "" ];then
		echo "请输入业务地址"
			exit 1
fi

if [ "${3}" = "" ];then
                echo "请输入服务器网关地址"
                        exit 1
fi

if [ "${4}" = "" ];then
                echo "请输入默认语言"
                        exit 1
fi



export PATH=$PATH:${CURR_DIR}

#磁盘检测挂载
#sys_check_sd.sh
sys_check_vd.sh
/bin/sleep 20
mkdir -p /data /record/vdc
mount /dev/vdb1 /data
mount /dev/vdc1 /record/vdc
echo "/dev/vdb1 /data xfs defaults 1 1" >>/etc/fstab
echo "/dev/vdc1 /record/vdc xfs defaults 1 1" >>/etc/fstab


#创建普通用户
host_name=business
echo "127.0.0.1 ${host_name}" >>/etc/hosts
echo "${host_name}" >/etc/hostname
hostnamectl set-hostname ${host_name}
user=mix_usr
pwd=`date +%s | sha256sum | base64 | head -c 32 ; echo`
egrep ${user} /etc/passwd >& /dev/null
if [ $? -ne 0 ]; then
useradd ${user}
echo ${pwd} | passwd --stdin ${user}
echo -e "\033[43;30m\e[31m用户名：${user} 密码：${pwd}\e[0m"
echo "用户名：${user} 密码：${pwd}" #>/root/installTool/user.txt
chage -E -1 mix_usr
chmod u+s /usr/bin/crontab
fi

#2024-4-16新增sshmix_operation用户
sh /root/installTool/mix_operation_user.sh && rm -rf /root/installTool/mix_operation_user.sh

echo "mix_usr" > /etc/cron.allow
chown -R ${user}. /var/spool/cron/
#2023-5-9因主从并授权sudo
sed -i '/^root */a mix_usr ALL=(ALL:ALL) NOPASSWD:/usr/bin/netstat,/usr/sbin/netpdate,/usr/bin/date,/data/middle/chrony/sbin/chronyd,/usr/bin/ps,/usr/bin/kill' /etc/sudoers


sh /root/installTool/zhengshu/zsinstall.sh ${2}

#2023-6-13定义时间变量
timestamp=`date +%F`

#2023-6-13mysql共享库
yum -y install libatomic.aarch64 ntp expect net-tools  libtool-ltdl
#离线安装
rpm -ivh /root/installTool/rpm/libaio-0.3.112-2.oe2203.aarch64.rpm
rpm -ivh /root/installTool/rpm/chrony-3.5-3.p01.ky10.aarch64.rpm


#创建服务目录并授权
mkdir -p /data/middle /data/jaws /data/ops /data/download /data/paasfss /data/data  /data/log/ /data/log/middle/nginx/ /data/log/jaws /data/paasfss /paasfss /data/log/middle/opengauss/pg_log
mkdir -p /data/log/middle/redis
mkdir -p /data/log/middle/rabbitmq
mkdir -p /data/log/middle/consul
chown -R ${user}. /data
chown -R ${user}. /paasfss
chown -R ${user}. /record

tar xf /root/installTool/ops.tar.gz  -C /data/
cp -r /root/installTool/zhengshu/* /data/ops/cert/

chown -R ${user}. /data

#2024-4-16增加证书权限为600动作
chmod 600  /data/ops/cert/*.key && chmod 600  /data/ops/cert/*.pem
chmod 600  -R /data/ops/cert/nginx/*.pem && chmod 600  -R /data/ops/cert/nginx/*.key

#系统优化
cat > /etc/sysctl.conf << EOF
# 关闭 ipv6
net.ipv6.conf.all.disable_ipv6 = 0
net.ipv6.conf.default.disable_ipv6 = 0
net.ipv6.conf.lo.disable_ipv6 = 0

# 开启反向路径过滤
net.ipv4.conf.all.rp_filter = 1
net.ipv4.conf.default.rp_filter = 1

#处理无源路由的包
net.ipv4.conf.all.accept_source_route = 0
net.ipv4.conf.default.accept_source_route = 0

# 关闭路由转发
net.ipv4.ip_forward = 0
net.ipv4.conf.all.send_redirects = 0
net.ipv4.conf.default.send_redirects = 0

# 确保无人能修改路由表
net.ipv4.conf.all.accept_redirects = 0
net.ipv4.conf.default.accept_redirects = 0
net.ipv4.conf.all.secure_redirects = 0
net.ipv4.conf.default.secure_redirects = 0

# 内核放弃建立连接之前发送SYNACK/SYN包的数量
net.ipv4.tcp_synack_retries = 1
net.ipv4.tcp_syn_retries = 1

# 允许将TIME-WAIT sockets重新用于新的TCP 连接
net.ipv4.tcp_tw_reuse = 1
net.ipv4.tcp_tw_recycle = 1
net.ipv4.tcp_timestamps = 1
net.ipv4.tcp_mem = 94500000 915000000 927000000

net.ipv4.tcp_fin_timeout = 30 # 设置TCP三次请求的fin状态超时
net.ipv4.tcp_keepalive_time = 600 # 设置TCP发送keepalive的频度
net.ipv4.tcp_syncookies = 1 # 加强对抗SYN Flood的能力
net.ipv4.tcp_keepalive_intvl = 2 # 探测包发送时间的间隔设置
net.ipv4.tcp_keepalive_probes = 2 # 客户端无应答，探测包的发送次数
net.ipv4.tcp_max_tw_buckets = 55000 # 系统同时保持time-wait的最大数量
net.ipv4.tcp_rmem = 4096 87380 4194304 # 接受数据缓冲区范围
net.ipv4.tcp_wmem = 4096 16384 4194304 # 发送数据缓冲区范围
net.ipv4.tcp_retries2 = 5 # TCP失败重传次数
net.ipv4.ip_local_port_range = 1100 65000 # 允许系统打开的端口范围
net.ipv4.tcp_max_orphans = 3276800 # 防止简单的DoS 攻击
net.ipv4.tcp_max_syn_backlog = 262144 # 表示SYN队列的长度
net.ipv4.icmp_echo_ignore_broadcasts = 1 # 避免放大攻击
net.ipv4.icmp_ignore_bogus_error_responses = 1 # 开启恶意icmp错误消息保护
net.ipv4.conf.default.arp_announce = 2
net.ipv4.conf.lo.arp_announce=2
net.ipv4.conf.all.arp_announce=2
net.ipv4.tcp_sack = 1
net.ipv4.tcp_window_scaling = 1

net.core.wmem_default = 8388608
net.core.rmem_default = 8388608
net.core.rmem_max = 16777216
net.core.wmem_max = 16777216
net.core.netdev_max_backlog = 262144
net.core.somaxconn = 655350 # 系统同时发起的tcp连接数

net.netfilter.nf_conntrack_max=655350 # 修改防火墙表大小
net.netfilter.nf_conntrack_tcp_timeout_established = 300 # 设置tcp确认超时时间
net.netfilter.nf_conntrack_tcp_timeout_time_wait = 12 # 设置tcp等待时间
net.netfilter.nf_conntrack_tcp_timeout_close_wait = 60 # 设置tcp关闭等待时间
net.netfilter.nf_conntrack_tcp_timeout_fin_wait = 120 # 设置tcp fin状态的超时时间

kernel.shmmax = 68719476736 #用户postfix邮件服务器
kernel.shmall = 4294967296
kernel.sysrq = 0 # 关闭sysrq功能
kernel.pid_max = 65536 # 允许更多的PIDs
kernel.core_uses_pid = 1 # core文件名中添加pid作为扩展名
kernel.msgmnb = 65536 # 修改消息队列长度

kernel.msgmax = 65536

fs.file-max = 655350 # 增加系统文件描述符限制
vm.swappiness = 0
vm.max_map_count = 262144
EOF

mv /etc/security/limits.conf /etc/security/limits.conf.bak-$timestamp
cat >> /etc/security/limits.conf << EOF
# noproc 是代表最大进程数
# nofile 是代最大文件打开数
root hard nofile 655350
root soft nofile 655350
* soft nofile 655350
* hard nofile 655350
* soft nproc 655350
* hard nproc 655350
* - nofile 655350
EOF

echo "DefaultLimitNOFILE=655350" >> /etc/systemd/system.conf

mv /etc/security/limits.d/20-nproc.conf /etc/security/limits.d/20-nproc.conf.bak-$timestamp
echo -e "*          soft    nproc     40960\nroot       soft    nproc     unlimited" >> /etc/security/limits.d/20-nproc.conf >/dev/null 2>&1
lsmod |grep conntrack >/dev/null 2>&1
modprobe ip_conntrack >/dev/null 2>&1
ulimit -n 655350
sysctl -p >/dev/null 2>&1 && systemctl daemon-reload
#关闭防火墙
systemctl stop firewalld.service
systemctl disable firewalld.service

#2025-1-8环境变量
echo "export GAUSSHOME=/data/middle/openGauss" >> /etc/profile.d/opengauss.sh
echo "export PATH=\$GAUSSHOME/bin:\$PATH" >> /etc/profile.d/opengauss.sh
echo "export LD_LIBRARY_PATH=\$GAUSSHOME/lib:\$LD_LIBRARY_PATH" >> /etc/profile.d/opengauss.sh
echo "export GS_CLUSTER_NAME=dbCluster" >> /etc/profile.d/opengauss.sh
chown $user. -R /etc/profile.d/opengauss.sh
source /etc/profile.d/opengauss.sh


#配置文件修改
IPADDR=`grep -w IPADDR config.ini |awk -F = '{print $NF}'`
LANADDR=`grep LANADDR config.ini |awk -F = '{print $NF}'`
NETWORK_CIDR=`grep NETWORK_CIDR config.ini |awk -F = '{print $NF}'|awk -F / '{print $1}'`
HOST_DOMAIN=`grep HOST_DOMAIN config.ini |awk -F = '{print $NF}'`
GATEWAY=`grep -w GATEWAY config.ini |awk -F = '{print $NF}'`
NETWORK_EXCLUDEADDR=`grep -w NETWORK_EXCLUDEADDR config.ini |awk -F = '{print $NF}'`
BUSINESS_INNERIP_REG=`grep BUSINESS_INNERIP_REG config.ini |awk -F = '{print $NF}'|awk -F / '{print $1}'`

sed -i "s#\<${IPADDR}\>#${1}#" config.ini
sed -i "s#\<${LANADDR}\>#${1}#" config.ini
sed -i "s#\<4444\>#$2#" config.ini
sed -i "s#\<${NETWORK_CIDR}\>#${3}#" config.ini
sed -i "s#\<${HOST_DOMAIN}\>#${2}#" config.ini
sed -i "s#\<${GATEWAY}\>#${3}#" config.ini
sed -i "s#\<${NETWORK_EXCLUDEADDR}\>#${3}#" config.ini
sed -i "s#\<${BUSINESS_INNERIP_REG}\>#${3}#" config.ini
sed -i "s#\<1.1.1.1\>#$1#" mix_saas9099.tpl
sed -i "s#\<1.1.1.1\>#$1#" mix_saas9099_ipv6.tpl
sed -i "s#\<1.1.1.1\>#$1#" httpsflv2.tpl
sed -i "s#\<3333\>#$1#" chrony.conf


#2023-5-9因主从新增修改相关配置
sed -i "s#\<3333\>#$1#" config.ini
sed -i "s#\<3333\>#$1#" rabbitmq.conf
sed -i "s#\<3333\>#$1#" redis.conf
sed -i "s#\<3333\>#$1#" import_sql
sed -i "s#\<3333\>#$1#" paas_inside9081.conf
sed -i "s#\<3333\>#$1#" redis_flush_mix.sh
sed -i "s#\<3333\>#$1#" autobackupdb.sh
sed -i "s#\<3333\>#$1#" postgresql.conf
sed -i "s#\<3333\>#$1#" pg_hba.conf

#2023-5-25增加cms配置,mac地址修改动作
server_id=$(grep SERVER_ID config.ini | awk -F = '{print $NF}')
SERVER_ID=$(ip addr | grep "link/ether" | awk 'NR==1{print $2}')
sed -i "s#${server_id}#${SERVER_ID}#" config.ini

#2024-4-15新增语言参数
sed -i "s#\<2222\>#$4#" config.ini

#2025-2-28ipv6
# 获取指定IP地址所在的网卡名称
interface=$(ip -o addr show | grep "$1" | awk '{print $2}')

# 检查该网卡是否涉及IPv6地址
ipv6_address=$(ip -6 addr show dev "$interface" scope global | grep inet6 | awk '{print $2}' | cut -d'/' -f1)

nginx_dir=/root/installTool

if [ -n "$ipv6_address" ]; then
    # 如果存在IPv6地址，则替换nginx.conf中的aaaa
    cat  $nginx_dir/nginx_ipv6.conf > $nginx_dir/nginx.conf
    cat  $nginx_dir/mix_saas9099_ipv6.tpl > $nginx_dir/mix_saas9099.tpl
    sed -i "s/aaaa/$ipv6_address/g" $nginx_dir/nginx.conf
    sed -i "s/aaaa/$ipv6_address/g" $nginx_dir/mix_saas9099.tpl
else
    # 如果不存在IPv6地址，则跳过
    echo "网卡 $interface 不涉及IPv6地址，跳过替换操作。" >/dev/null 2>&1
fi


allowUrl="$5"
echo "allowUrl：${allowUrl}"
if [[ -n "${allowUrl}" ]]; then
    sed -i "s/^.*Access-Control-Allow-Origin.*$/add_header Access-Control-Allow-Origin $allowUrl;/g" $nginx_dir/mix_saas9099.tpl
else
    sed -i "s/^.*Access-Control-Allow-Origin.*$/add_header Access-Control-Allow-Origin *;/g" $nginx_dir/mix_saas9099.tpl
fi

