#!/bin/bash

CONF=/data/ops/config.ini
OFFLINE_CONFIG_ROOT_KEY_COMPONENT1=$(grep "OFFLINE_CONFIG_ROOT_KEY_COMPONENT1" ${CONF} | awk -F = '{print $2}')
OFFLINE_CONFIG_ROOT_KEY_SALT=$(grep "OFFLINE_CONFIG_ROOT_KEY_SALT" ${CONF} | awk -F = '{print $2}')
REDIS_PASSWORD=$(grep "REDIS_PASSWORD=" ${CONF} | awk -F REDIS_PASSWORD= '{print $2}')
PASSWORD=$(/data/ops/cert/amah_tool -role=config -root_key.component1=${OFFLINE_CONFIG_ROOT_KEY_COMPONENT1} -root_key.salt=${OFFLINE_CONFIG_ROOT_KEY_SALT} -ciphertext=${REDIS_PASSWORD})

chmod 700 /data/middle/redis/redis_flush_mix.sh

auth=${PASSWORD}

echo "flushall" | /data/middle/redis/bin/redis-cli -u "redis://admin:${auth}@3333:6379"
