#!/bin/bash

CURR_DIR=$(cd `dirname $0`; pwd)

CONF=/root/installTool/config.ini
OFFLINE_CONFIG_ROOT_KEY_COMPONENT1=`grep "OFFLINE_CONFIG_ROOT_KEY_COMPONENT1" ${CONF} |awk -F = '{print $2}'`
OFFLINE_CONFIG_ROOT_KEY_SALT=`grep "OFFLINE_CONFIG_ROOT_KEY_SALT" ${CONF} |awk -F = '{print $2}'`
cert_pwd=$(./amah_tool -role=rand -length=12)
domain=$1

#生成证书
cd ${CURR_DIR}
mkdir nginx
openssl req -new -newkey rsa:2048 -sha256 -nodes -out ${domain}.csr -keyout ${domain}.key -subj "/C=CN/ST=Shandong/L=Jinan/O=Jovision/OU=Jovision/CN=${domain}"
sed  -i -r "s#(^IP.2=)(.*$)#\1${domain}#g" http.ext
openssl x509 -req -days 36135 -in ${domain}.csr -signkey ${domain}.key -out ${domain}.crt -extfile http.ext
cp ${domain}.crt media.pem && cp ${domain}.crt ${domain}.pem && cp ${domain}.crt nginx/saas.pem  && zip -r ssl_certificate.zip ${domain}.pem ${domain}.key ${domain}.crt
openssl rsa -in ${domain}.key -aes256 -passout pass:${cert_pwd} -out media.key
cp media.key nginx/saas.key
rm -rf ${domain}.key ${domain}.csr *.crt ${domain}.pem ${domain}.key 
mkdir -p /data//download/public/cert/
cp ssl_certificate.zip /data//download/public/cert/


cd ${CURR_DIR}
media_key=$(./amah_tool -role=config -root_key.component1=${OFFLINE_CONFIG_ROOT_KEY_COMPONENT1} -root_key.salt=${OFFLINE_CONFIG_ROOT_KEY_SALT} -plaintext=${cert_pwd})
saas_key=$(./amah_tool -role=config -root_key.component1=${OFFLINE_CONFIG_ROOT_KEY_COMPONENT1} -root_key.salt=${OFFLINE_CONFIG_ROOT_KEY_SALT} -plaintext=${cert_pwd})
echo ${saas_key} 
echo ${media_key}
sed -i "s#VTdMSmFIZFNHY2RPdHQ5Qg==.DD0xaCWG5QuCMBigr3MBzw==.BLBqhT3M7p58X05q1G-imXcSLyzgp4gESHOW8ghd8hg=#${media_key}#g" ${CONF}
sed -i "s#00001111#${saas_key}#g" ${CONF}
